/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.ui.UIHelper;

public class ContextMenu
extends AbstractContainerElement {
    public static final ResourceLocation BACKGROUND = new FiguraIdentifier("textures/gui/context.png");
    private final int minWidth;
    private final List<ContextButton> entries = new ArrayList<ContextButton>();
    public GuiEventListener parent;
    private ContextMenu nestedContext;

    public ContextMenu(GuiEventListener parent, int minWidth) {
        super(0, 0, minWidth, 2);
        this.minWidth = minWidth;
        this.parent = parent;
        this.setVisible(false);
    }

    public ContextMenu(GuiEventListener parent) {
        this(parent, 0);
    }

    public ContextMenu() {
        this(null);
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        UIHelper.blitSliced(gui, this.getX(), this.getY(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 16, 16, 48, 16, BACKGROUND);
        int y = this.getY() + 1;
        for (int i = 0; i < this.entries.size(); ++i) {
            int height = this.entries.get(i).getHeight();
            UIHelper.blitSliced(gui, this.getX() + 1, y, this.getWidth() - 2, height, i % 2 == 1 ? 32.0f : 16.0f, 0.0f, 16, 16, 48, 16, BACKGROUND);
            this.entries.get(i).render(gui, mouseX, mouseY, delta);
            y += height;
        }
        if (this.nestedContext != null) {
            this.nestedContext.render(gui, mouseX, mouseY, delta);
            GuiEventListener guiEventListener = this.nestedContext.parent;
            if (guiEventListener instanceof Button) {
                Button button = (Button)guiEventListener;
                button.setHovered(true);
            }
        }
    }

    public void addAction(Component name, Component tooltip, Button.OnPress action) {
        this.addElement(new ContextButton(this.getX(), this.getY() + this.getHeight(), name, tooltip, this, action));
    }

    public void addDivisor() {
        this.addElement(new ContextDivisor(this.getX(), this.getY() + this.getHeight()));
    }

    public void addTab(Component name, Component tooltip, ContextMenu context) {
        TabButton button = new TabButton(this.getX(), this.getY() + this.getHeight(), name, tooltip, this, context);
        this.addElement(button);
        context.parent = button;
        this.children.add(context);
    }

    private void addElement(ContextButton element) {
        this.children.add(element);
        this.entries.add(element);
        this.updateDimensions();
    }

    private void clearNest() {
        if (this.nestedContext != null) {
            this.nestedContext.clearNest();
            this.nestedContext = null;
        }
    }

    public void updateDimensions() {
        this.setWidth(this.minWidth);
        this.setHeight(2);
        for (ContextButton entry : this.entries) {
            this.setWidth(Math.max(entry.getTrueWidth() + 8, this.getWidth()));
            this.setHeight(this.getHeight() + entry.getHeight());
        }
        for (ContextButton entry : this.entries) {
            entry.setWidth(this.getWidth() - 2);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.clearNest();
    }

    @Override
    public void setX(int x) {
        int clientWidth;
        int realWidth = x + this.getWidth();
        if (realWidth > (clientWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth())) {
            x -= realWidth - clientWidth;
        }
        super.setX(x);
        for (ContextButton button : this.entries) {
            button.setX(x + 1);
            if (!(button instanceof TabButton)) continue;
            TabButton tab = (TabButton)button;
            tab.context.setX(tab.getX() + tab.getWidth());
        }
    }

    @Override
    public void setY(int y) {
        int clientHeight;
        int realHeight = y + this.getHeight();
        if (realHeight > (clientHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight())) {
            y -= realHeight - clientHeight;
        }
        super.setY(y);
        int heigth = y + 1;
        for (ContextButton button : this.entries) {
            button.setY(heigth);
            heigth += button.getHeight();
            if (!(button instanceof TabButton)) continue;
            TabButton tab = (TabButton)button;
            tab.context.setY(tab.getY() - 1);
        }
    }

    public List<? extends AbstractWidget> getEntries() {
        return this.entries;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        this.setFocused(null);
        return result;
    }

    private static class ContextButton
    extends Button {
        protected final ContextMenu parent;

        public ContextButton(int x, int y, Component text, Component tooltip, ContextMenu parent, Button.OnPress pressAction) {
            super(x, y, 0, 16, text, tooltip, pressAction);
            this.shouldHaveBackground(false);
            this.parent = parent;
        }

        protected ContextButton(int x, int y, int height) {
            super(x, y, 0, height, (Component)Component.empty(), null, button -> {});
            this.shouldHaveBackground(false);
            this.parent = null;
        }

        @Override
        protected void renderText(GuiGraphics gui, float delta) {
            Font font = Minecraft.getInstance().font;
            Component component = this.getMessage();
            int n = this.getX() + 3;
            float f = (float)this.getY() + (float)this.getHeight() / 2.0f;
            Objects.requireNonNull(font);
            gui.drawString(font, component, n, (int)(f - 9.0f / 2.0f), this.getTextColor());
        }

        @Override
        public boolean isMouseOver(double mouseX, double mouseY) {
            if (UIHelper.isMouseOver(this.getX(), this.getY(), this.getWidth(), this.getHeight(), mouseX, mouseY, true)) {
                UIHelper.setTooltip(this.tooltip);
                this.parent.clearNest();
                return true;
            }
            return false;
        }

        public int getTrueWidth() {
            return Minecraft.getInstance().font.width((FormattedText)this.getMessage());
        }
    }

    private static class ContextDivisor
    extends ContextButton {
        public ContextDivisor(int x, int y) {
            super(x, y, 9);
        }

        @Override
        public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            gui.fill(this.getX() + 4, this.getY() + 4, this.getX() + this.getWidth() - 4, this.getY() + 5, -16777216 + ChatFormatting.DARK_GRAY.getColor());
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return false;
        }
    }

    private static class TabButton
    extends ContextButton {
        private static final Component ARROW = Component.literal((String)">").setStyle(Style.EMPTY.withFont(UIHelper.UI_FONT));
        private final ContextMenu context;

        public TabButton(int x, int y, Component text, Component tooltip, ContextMenu parent, ContextMenu context) {
            super(x, y, text, tooltip, parent, button -> {});
            this.context = context;
            this.context.setVisible(true);
        }

        @Override
        public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            super.renderWidget(gui, mouseX, mouseY, delta);
            Font font = Minecraft.getInstance().font;
            int n = this.getX() + this.getWidth() - font.width((FormattedText)ARROW) - 3;
            float f = (float)this.getY() + (float)this.getHeight() / 2.0f;
            Objects.requireNonNull(font);
            gui.drawString(font, ARROW, n, (int)(f - 9.0f / 2.0f), this.getTextColor());
        }

        @Override
        public boolean isMouseOver(double mouseX, double mouseY) {
            boolean mouseOver = UIHelper.isMouseOver(this.getX(), this.getY(), this.getWidth(), this.getHeight(), mouseX, mouseY, true);
            if (mouseOver || this.parent.nestedContext == this.context) {
                UIHelper.setTooltip(this.tooltip);
                this.parent.nestedContext = this.context;
                if (mouseOver) {
                    this.context.nestedContext = null;
                }
                return true;
            }
            return false;
        }

        @Override
        public int getTrueWidth() {
            return super.getTrueWidth() + Minecraft.getInstance().font.width((FormattedText)Component.literal((String)" ").append(ARROW));
        }
    }
}

